// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "sha2.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE	hInst;
extern	HWND		hMainWindow;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpszAppName;
extern	LPBYTE		lpKeyBuffer1;
extern	LPBYTE		lpKeyBuffer2;
extern	DWORD		dwSignatureSize;
extern	DWORD		dwPublicComp;
extern	TCHAR		szUserID;
extern	int			iLengthOfUserId;
extern	DWORD		dwOurTimestamp;
extern	DWORD		dwOurTimestamp1;
extern	MD5_CTX		Md5Context;
extern	BYTE		Md5Digest;
extern	SHACONTEXT	ShaContext;
extern	BYTE		ShaDigest;
extern	sha512_ctx	Sha512Context;
extern	BYTE		Sha512Digest;
extern	WORD		wMd5Byte1;
extern	BYTE		Temp1;
extern	BYTE		D_Temp;
extern	BYTE		Prime_P;
extern	BYTE		Prime_Q;
extern	BYTE		U_Temp;
extern	DWORD		dwN_Bytes;
extern	DWORD		dwCountBytes;
extern	DWORD		dwCountBits;
extern	DWORD		dwTemp1Size;
extern	DWORD		dwTemp1Bits;
extern	BYTE		KeySID[KEY_ID_SIZE];
extern	BOOL		bCancelOperation;
extern	DWORD		dwKeyRingFilesActive;
extern	BOOL		bProcessInProgress;
extern	HWND		hStatusBar;
extern	BOOL		bUseMd5;
extern	TCHAR		szDemoPublic[];
extern	TCHAR		szDemoSecret[];
extern	CONFIG		cfg;

// SHFILEINFO structures to return the display name of a file.
//............................................................
SHFILEINFO	shfi1;
SHFILEINFO	shfi2;

// File specifications for our public and secret key rings
// and index files, and one temporary backup file. 
//.........................................................
TCHAR		szPublicRingKeyId[MAX_PATH];
TCHAR		szPublicRingUserId[MAX_PATH];
TCHAR		szSecretRingKeyId[MAX_PATH];
TCHAR		szSecretRingUserId[MAX_PATH];

TCHAR		szBackUpFile[MAX_PATH];
TCHAR		szRings[] = "Key Rings: %s and %s";
TCHAR		szStatusBarRings[127];
BOOL		bDisplayRingsOnStatusBar;

// Files handles for the public and secret key rings and index files.
//...................................................................
HANDLE		hPublicKeyRing;
HANDLE		hPublicRingKeyId;
HANDLE		hPublicRingUserId;

HANDLE		hSecretKeyRing;
HANDLE		hSecretRingKeyId;
HANDLE		hSecretRingUserId;

HANDLE		hBackUpFile;

// We have a set of key ring and index files loaded.
//..................................................
BOOL		bKeyRingFilesLoaded;
BOOL		bTimerOn = FALSE;

// Load an existing set of RSA Public and Secret Key Rings.
// We have to create the index files for them too if they
// are not called from the rsa key generation procedure.
// Return TRUE if successful, else FALSE if error or cancel.
//.........................................................
BOOL LoadASetOfKeyRings(BOOL bProcessRunning, BOOL bCalledFromRsaKeyGen, HWND hParentWindow)
{
	OPENFILENAME	ofn;
	BOOL			bResult;
	BOOL			bValidKeyRing;
	int				iResult;
	DWORD			dwOldHelpTopic;
	DWORD			dwBytesRead;
	LPBYTE			lpFileDemo;
	BYTE			ReadBuffer[12];
	LPBYTE			lpReadBuffer = (LPBYTE)&ReadBuffer;

	if (!bProcessRunning)
	{
		// We have a process in progress.
		//...............................
		bProcessInProgress = TRUE;
	}
	// Change to the help topic for loading a set of key rings.
	//.........................................................
	dwOldHelpTopic = ChangeHelpTopic(IDH_LOADRSAKEYS);

	// If we have a set of key rings already loaded, confirm that
	// we want to replace them.
	//...........................................................
	if (!bProcessRunning && bKeyRingFilesLoaded)
	{
		iResult = MessageBoxProc(hMainWindow,IDS_CONFIRMATION,IDS_CHANGEKEYRINGS,
								 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);
		if (iResult == IDYES)
		{
			bResult = CloseAllKeyRingFiles();
			if (!bResult)
			{
				goto LoadEnd;
			}
			bResult = FALSE;
		}
		else
		{
			bResult = TRUE;
			goto LoadEnd;
		}
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	bResult = FALSE;

	// Initialize with specific information for a public key ring.
	//............................................................
	ofn.lpstrFile = cfg.szPublicKeyRing;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hParentWindow;
	ofn.lpstrFilter = TEXT("Key Ring Files [.rng]\0*.rng\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Open a Public Key Ring File");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_HIDEREADONLY | OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP);
	ofn.lpstrDefExt = TEXT("rng");
	ofn.lpfnHook = MyOFNHookProc;

	// Select and open a Public Key Ring File.
	//........................................
	while(TRUE)
	{
		// Zero the return string for the file name.
		//..........................................
		ZeroMemory(&cfg.szPublicKeyRing,MAX_PATH);

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto LoadEnd;
		}
		SaveDirName((LPBYTE)&cfg.szPublicKeyRing,SAVE_SOURCE,TRUE);

		// If we are generating a set of keys we cannot add them to the
		// Demo key ring.
		//.............................................................
		if (bCalledFromRsaKeyGen)
		{
			lpFileDemo = PathFindFileName((LPCTSTR)&cfg.szPublicKeyRing);
			iResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
								   (LPCTSTR)lpFileDemo,-1,(LPCTSTR)&szDemoPublic,-1);
			if (iResult == CSTR_EQUAL)
			{
				MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOPUBLICDEMO,
							   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
				continue;
			}
		}
		// Make sure we have a valid Public Key Ring File.
		//................................................
		hPublicKeyRing = CreateMyFile(cfg.szPublicKeyRing,GENERIC_READ | GENERIC_WRITE,
								      0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hPublicKeyRing)
		{
			goto LoadEnd;
		}
		// Read in the first byte of the file and see if it is 
		// correct for a public key ring.
		//....................................................
		bResult = ReadMyFile(cfg.szPublicKeyRing,hPublicKeyRing,lpReadBuffer,
							 1,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto LoadEnd;
		}
		__asm
		{
			mov		bValidKeyRing,TRUE
			mov		edi,lpReadBuffer
			mov		al,byte ptr [edi]
			and		al,CTB_MASK
			cmp		al,CTB_PUBLIC_KEY
			je		L1
			mov		bValidKeyRing,FALSE
		L1:
		}
		if (!bValidKeyRing)
		{
			bResult = CloseMyHandle(cfg.szPublicKeyRing,hPublicKeyRing);
			if (!bResult)
			{
				goto LoadEnd;
			}
			hPublicKeyRing = 0;
			SetLastError(IDS_NOTAVALIDPUBLICKEYRING);
			ErrorProcedure(cfg.szPublicKeyRing,IDS_CREATE_OPEN,MB_OK);
			bResult = FALSE;
			continue;
		}
		else
		{	
			dwKeyRingFilesActive++;
			break;
		}
	}

	bResult = FALSE;

	EmptyTheMessageQue();

	// Initialize with specific information for a secret key ring.
	//............................................................
	ofn.lpstrFile = cfg.szSecretKeyRing;
	ofn.lpstrTitle = TEXT("Open a Secret Key Ring File");

	// Select and open a Secret Key Ring File.
	//........................................
	while(TRUE)
	{
		// Zero the return string for the file name.
		//..........................................
		ZeroMemory(&cfg.szSecretKeyRing,MAX_PATH);
	
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto LoadEnd;
		}
		SaveDirName((LPBYTE)&cfg.szSecretKeyRing,SAVE_SOURCE,TRUE);

		// If we are generating a set of keys we cannot add them to the
		// Demo key ring.
		//.............................................................
		if (bCalledFromRsaKeyGen)
		{
			lpFileDemo = PathFindFileName((LPCTSTR)&cfg.szSecretKeyRing);
			iResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
								   (LPCTSTR)lpFileDemo,-1,(LPCTSTR)&szDemoSecret,-1);
			if (iResult == CSTR_EQUAL)
			{
				MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSECRETDEMO,
							   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
				continue;
			}
		}
		// Make sure we have a valid Secret Key Ring File.
		//................................................
		hSecretKeyRing = CreateMyFile(cfg.szSecretKeyRing,GENERIC_READ | GENERIC_WRITE,
									  0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hSecretKeyRing)
		{
			goto LoadEnd;
		}
		// Read in the first byte of the file and see if it is 
		// correct for a secret key ring.
		//....................................................
		bResult = ReadMyFile(cfg.szSecretKeyRing,hSecretKeyRing,lpReadBuffer,
							 1,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto LoadEnd;
		}
		__asm
		{
			mov		bValidKeyRing,TRUE
			mov		edi,lpReadBuffer
			mov		al,byte ptr [edi]
			and		al,CTB_MASK
			cmp		al,CTB_SECRET_KEY
			je		L2
			mov		bValidKeyRing,FALSE
		L2:
		}
		if (!bValidKeyRing)
		{
			bResult = CloseMyHandle(cfg.szSecretKeyRing,hSecretKeyRing);
			if (!bResult)
			{
				goto LoadEnd;
			}
			hSecretKeyRing = 0;
			SetLastError(IDS_NOTAVALIDSECRETKEYRING);
			ErrorProcedure(cfg.szPublicKeyRing,IDS_CREATE_OPEN,MB_OK);
			bResult = FALSE;
			continue;
		}
		else
		{	
			dwKeyRingFilesActive++;
			break;
		}
	}

	EmptyTheMessageQue();

	// If the procedure is not called from the rsa key generation
	// procedure, or the check procedure, we have to index and 
	// check the key rings.
	//...........................................................
	if (!bCalledFromRsaKeyGen)
	{
		bResult = IndexKeyRingFiles(hParentWindow);
		if (!bResult)
		{
			goto LoadEnd;
		}

		EmptyTheMessageQue();

		// Check our the key rings.
		//.........................
		bResult = CheckOutTheKeyRings(TRUE,hParentWindow);
		if (!bResult)
		{
			goto LoadEnd;
		}
		// If we have six active key ring and index files, enable
		// the menu items.
		//.......................................................
		if (dwKeyRingFilesActive == 6)
		{
			bKeyRingFilesLoaded = TRUE;
			EnableAllMenuItems(TRUE);
			KeyRingsForStatusBar();
		}
	}

	bResult = TRUE;
	LoadEnd:

	if (!bResult)
	{
		// If we had an error, or we cancelled out,
		// make sure all the files are closed.
		//.........................................
		CloseAllKeyRingFiles();
	}
	if (!bProcessRunning)
	{
		// We are done with the process.
		//..............................
		bProcessInProgress = FALSE;
	}

	ChangeHelpTopic(dwOldHelpTopic);
	return(bResult);
}

// Create a new set of RSA Public and Secret Key Rings.
// Return TRUE if successful, else FALSE.
//.....................................................
BOOL CreateANewSetOfKeyRings()
{
	OPENFILENAME		ofn;
	BOOL				bResult;
	HANDLE				hSearch;
	WIN32_FIND_DATA		wfd;

	// If we have a set of key rings already loaded we have to 
	// close them.
	//........................................................
	bResult = CloseAllKeyRingFiles();
	if (!bResult)
	{
		goto CreateEnd;
	}

	bResult = FALSE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DESTINATION);

	// Initialize with specific information for getting a public
	// key ring name.
	//..........................................................
	ofn.lpstrFile = cfg.szPublicKeyRing;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Key Ring Files [.rng]\0*.rng\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Save Public Key Ring As");
	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST |OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING |OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = TEXT("rng");
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&cfg.szPublicKeyRing,MAX_PATH);

		// Get the name and path we want to use for our public key ring.
		//..............................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			goto CreateEnd;
		}
		SaveDirName((LPBYTE)&cfg.szPublicKeyRing,SAVE_DESTINATION,TRUE);

		hSearch = FindFirstFile((LPCTSTR)&cfg.szPublicKeyRing,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			break;
		}
		EmptyTheMessageQue();

		// The file exists, warn the user so he can enter another
		// file name.
		//.......................................................
		FindClose(hSearch);
		SetLastError(IDS_ALREADYEXISTS);
		ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_FINDFIRSTFILE,MB_OK);
	}
	EmptyTheMessageQue();

	// Create the publickey ring file.
	//................................
	hPublicKeyRing = CreateMyFile((LPTSTR)&cfg.szPublicKeyRing,GENERIC_READ | GENERIC_WRITE,
								  0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hPublicKeyRing)
	{
		goto CreateEnd;
	}
	dwKeyRingFilesActive++;

	// Initialize with specific information for getting a secret
	// key ring name.
	//..........................................................
	ofn.lpstrFile = cfg.szSecretKeyRing;
	ofn.lpstrTitle = TEXT("Save Secret Key Ring As");

	while(TRUE)
	{
		ZeroMemory(&cfg.szSecretKeyRing,MAX_PATH);

		// Get the name and path we want to use for our secrt key ring.
		//.............................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			goto CreateEnd;
		}
		SaveDirName((LPBYTE)&cfg.szSecretKeyRing,SAVE_DESTINATION,TRUE);

		hSearch = FindFirstFile((LPCTSTR)&cfg.szSecretKeyRing,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			break;
		}
		EmptyTheMessageQue();

		// The file exists, warn the user so he can enter another
		// file name.
		//.......................................................
		FindClose(hSearch);
		SetLastError(IDS_ALREADYEXISTS);
		ErrorProcedure((LPTSTR)&cfg.szSecretKeyRing,IDS_FINDFIRSTFILE,MB_OK);
	}
	
	EmptyTheMessageQue();

	// Create the secret key ring.
	//............................
	hSecretKeyRing = CreateMyFile((LPTSTR)&cfg.szSecretKeyRing,GENERIC_READ | GENERIC_WRITE,
								  0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hSecretKeyRing)
	{
		bResult = FALSE;
		goto CreateEnd;
	}
	dwKeyRingFilesActive++;

	bResult = TRUE;

	CreateEnd:

	// If we did not create both of the key rings we have to make
	// sure they are all deleted.
	//...........................................................
	if (!bResult)
	{
		if (hPublicKeyRing)
		{
			CloseMyHandle((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing);
			DeleteMyFile((LPTSTR)&cfg.szPublicKeyRing);
			hPublicKeyRing = 0;
			dwKeyRingFilesActive--;
		}
		if (hSecretKeyRing)
		{
			CloseMyHandle((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing);
			DeleteMyFile((LPTSTR)&cfg.szSecretKeyRing);
			hSecretKeyRing = 0;
			dwKeyRingFilesActive--;
		}
	}
	return(bResult);
}

// Close the key ring and index files and delete the index files.
// Returns TRUE if successful, and FALSE if we have an error.
//...............................................................
BOOL CloseAllKeyRingFiles()
{
	TCHAR	cBuffer[24];
	BOOL	bResult = TRUE;
	BOOL	bDisableMenuItems = FALSE;

	if (dwKeyRingFilesActive)
	{
		bDisableMenuItems = TRUE;
	}

	if (hPublicKeyRing)
	{
		bResult = CloseMyHandle(cfg.szPublicKeyRing,hPublicKeyRing);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hPublicKeyRing = 0;
		dwKeyRingFilesActive--;
	}

	if (hSecretKeyRing)
	{
		bResult = CloseMyHandle(cfg.szSecretKeyRing,hSecretKeyRing);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hSecretKeyRing = 0;
		dwKeyRingFilesActive--;
	}

	if (hPublicRingKeyId)
	{
		bResult = CloseMyHandle(szPublicRingKeyId,hPublicRingKeyId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hPublicRingKeyId = 0;

		bResult = DeleteMyFile(szPublicRingKeyId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		dwKeyRingFilesActive--;
	}

	if (hPublicRingUserId)
	{
		bResult = CloseMyHandle(szPublicRingUserId,hPublicRingUserId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hPublicRingUserId = 0;

		bResult = DeleteMyFile(szPublicRingUserId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		dwKeyRingFilesActive--;
	}

	if (hSecretRingKeyId)
	{
		bResult = CloseMyHandle(szSecretRingKeyId,hSecretRingKeyId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hSecretRingKeyId = 0;

		bResult = DeleteMyFile(szSecretRingKeyId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		dwKeyRingFilesActive--;
	}

	if (hSecretRingUserId)
	{
		bResult = CloseMyHandle(szSecretRingUserId,hSecretRingUserId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		hSecretRingUserId = 0;

		bResult = DeleteMyFile(szSecretRingUserId);
		if (!bResult)
		{
			goto CloseEnd;
		}
		dwKeyRingFilesActive--;
	}

	CloseEnd:
	
	// Disable the menu items if they were enabled, even if we
	// have an error.
	//........................................................
	if (bDisableMenuItems)
	{
		// We do not have any key ring or index files loaded.
		//...................................................
		bKeyRingFilesLoaded = FALSE;
		bDisplayRingsOnStatusBar = FALSE;

		// Reset the status bar to ready.
		//...............................
		if (!bTimerOn)
		{
			LoadString(hInst,IDS_READY,cBuffer,sizeof(cBuffer));
			SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)cBuffer);
		}
	}
	EnableAllMenuItems(bKeyRingFilesLoaded);
	return(bResult);
}

// Delete the index files and backup file.
//........................................
VOID DeleteIndexFiles()
{
	DeleteMyFile(szPublicRingKeyId);
	DeleteMyFile(szPublicRingUserId);
	DeleteMyFile(szSecretRingKeyId);
	DeleteMyFile(szSecretRingUserId);
	DeleteMyFile(szBackUpFile);
}

// Rewind all the key ring and index files to their beginning.
// Returns TRUE if no error, else FALSE.
//............................................................
BOOL RewindAllKeyRingFiles()
{
	LARGE_INTEGER	li;
	BOOL			bResult = FALSE;

	if (hPublicKeyRing)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(cfg.szPublicKeyRing,hPublicKeyRing,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	if (hSecretKeyRing)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(cfg.szSecretKeyRing,hSecretKeyRing,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	if (hPublicRingKeyId)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(szPublicRingKeyId,hPublicRingKeyId,li.QuadPart,
									   FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	if (hPublicRingUserId)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(szPublicRingUserId,hPublicRingUserId,li.QuadPart,
									   FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	if (hSecretRingKeyId)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(szSecretRingKeyId,hSecretRingKeyId,li.QuadPart,
									   FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	if (hSecretRingUserId)
	{
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(szSecretRingUserId,hSecretRingUserId,li.QuadPart,
									   FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto RewindEnd;
		}
	}
	// We got them all rewound.
	//.........................
	bResult = TRUE;
	RewindEnd:
	return(bResult);
}

// Flush all key ring and index file buffers to disk.
// Returns FALSE if there was an error.
//...................................................
BOOL FlushAllFiles()
{
	BOOL	bResult = TRUE;

	if (hPublicKeyRing)
	{
		bResult = FlushMyFile(cfg.szPublicKeyRing,hPublicKeyRing);
		if (!bResult)
		{
			goto FlushEnd;
		}
	}
	if (hSecretKeyRing)
	{
		bResult = FlushMyFile(cfg.szSecretKeyRing,hSecretKeyRing);
		if (!bResult)
		{
			goto FlushEnd;
		}
	}
	if (hPublicRingKeyId)
	{
		bResult = FlushMyFile(szPublicRingKeyId,hPublicRingKeyId);
		if (!bResult)
		{
			goto FlushEnd;
		}
	}
	if (hPublicRingUserId)
	{
		bResult = FlushMyFile(szPublicRingUserId,hPublicRingUserId);
		if (!bResult)
		{
			goto FlushEnd;
		}
	}
	if (hSecretRingKeyId)
	{
		bResult = FlushMyFile(szSecretRingKeyId,hSecretRingKeyId);
		if (!bResult)
		{
			goto FlushEnd;
		}
	}
	if (hSecretRingUserId)
	{
		bResult = FlushMyFile(szSecretRingUserId,hSecretRingUserId);
	}

	FlushEnd:
	return(bResult);
}

// SignMyKey uses lpKeyBuffer2 to build the parts to calculate
// the Md5 or Sha message digest.
// 
// Entry: Public Key in lpKeyBuffer1 and size of public key
//        packet in dwPublicComp. User Id in szUserID if needed.
//        p, q, d, u, and n bytes initialized.
//
// Exit: Signature in lpKeyBuffer2 and size of signature in
//       dwSignatureSize.
//..............................................................
VOID SignMyKey(DWORD dwTypeOfSignature)
{
	LPBYTE	lpKeyBuffer2Dup;
	BYTE	DigestSize;
	BOOL	bUseSha512 = FALSE;

	lpKeyBuffer2Dup = lpKeyBuffer2;

	if (dwN_Bytes > SHA512_MIN_KEY_SIZE)
	{
		bUseSha512 = TRUE;
	}
	// Contrary to documentation we include the CTB byte and
	// length field of the public key in the Md5 calculation.
	//.......................................................
	ZeroMemory(lpKeyBuffer2,SIZE_BUILD_BUFF);
	CopyMemory(lpKeyBuffer2,lpKeyBuffer1,dwPublicComp);
	dwSignatureSize = dwPublicComp;
	lpKeyBuffer2Dup += dwPublicComp;

	// Now add the User Id without the CTB or length fields. If
	// this is a compromise certificate do not include the User Id.
	//.............................................................
	if (dwTypeOfSignature != KEY_COMPROMISE)
	{
		CopyMemory(lpKeyBuffer2Dup,&szUserID,iLengthOfUserId);
		dwSignatureSize += iLengthOfUserId;
		lpKeyBuffer2Dup += iLengthOfUserId;
	}

	__asm
	{
		mov		edi,lpKeyBuffer2Dup
		mov		eax,dwTypeOfSignature
		stosb
		push	edi
	}
	GetTimestamp(TRUE);

	if (bUseMd5)
	{
		__asm
		{
			pop		edi
			bswap	eax
			stosd
			mov		dwOurTimestamp,eax
			add		dwSignatureSize,SKE_APPEND_LGTH
			mov		DigestSize,SKE_APPEND_LGTH
		}
		// Perform the Md5 Calculations.
		//..............................
		Md5Initialize(&Md5Context);
		Md5Update(&Md5Context,lpKeyBuffer2,dwSignatureSize);
		Md5Final(&Md5Digest,&Md5Context);

		// Save the first two bytes of the Md5 digest.
		//............................................
		__asm
		{
			mov		eax,dword ptr Md5Digest
			mov		wMd5Byte1,ax
		}
	}
	else
	{
		// We are using the Sha message digest. 
		//.....................................
		__asm
		{
			pop		edi
			bswap	eax
			stosd
			mov		dwOurTimestamp,eax
			mov		dwOurTimestamp1,edx
			mov		eax,dword ptr KeySID
			stosd
			mov		eax,dword ptr KeySID[4]
			stosd
			mov		al,RSA_ALGORITHM
			shl		dl,1
			or		al,dl
			stosb
			add		dwSignatureSize,SKE_SHA_APPEND_LGTH
			mov		DigestSize,SKE_SHA_APPEND_LGTH
		}
		if (bUseSha512)
		{
			sha512_begin(&Sha512Context);
			sha512_hash(lpKeyBuffer2,dwSignatureSize,&Sha512Context);
			sha512_end(&Sha512Digest,&Sha512Context);

			// Save the first two bytes of the sha512 digest.
			//...............................................
			__asm
			{
				mov		eax,dword ptr Sha512Digest
				mov		wMd5Byte1,ax
			}
		}
		else
		{
			// Perform the Sha calculations.
			//..............................
			ShaInit(&ShaContext);
			ShaUpdate(&ShaContext,lpKeyBuffer2,dwSignatureSize);
			ShaFinal(&ShaDigest,&ShaContext);

			// Save the first two bytes of the sha1 digest.
			//.............................................
			__asm
			{
				mov		eax,dword ptr ShaDigest
				mov		wMd5Byte1,ax
			}
		}
	}
	// Encrypt the message digest for the signature packet.
	// Leave it in Temp1.
	//.....................................................
	ZeroMemory(lpKeyBuffer2,SIZE_BUILD_BUFF);
	ClearEncVariables();

	if (bUseMd5)
	{
		RsaPriEnc(&Temp1,&Md5Digest,MD5_DIGEST_SIZE,&D_Temp,&Prime_P,&Prime_Q,
				  &U_Temp,dwN_Bytes);
	}
	else
	{
		if (bUseSha512)
		{
			RsaPriEnc(&Temp1,&Sha512Digest,SHA512_DIGEST_SIZE,&D_Temp,&Prime_P,&Prime_Q,
					  &U_Temp,dwN_Bytes);
		}
		else
		{
			RsaPriEnc(&Temp1,&ShaDigest,SHA_DIGEST_SIZE,&D_Temp,&Prime_P,&Prime_Q,
					  &U_Temp,dwN_Bytes);
		}
	}
	CheckForMessages();
	if (bCancelOperation)
	{
		goto L1;
	}
	// Store the size in bytes and bits of Temp1.
	//...........................................
	dwTemp1Size = dwCountBytes;
	dwTemp1Bits = dwCountBits;
	dwSignatureSize = dwCountBytes;
	dwSignatureSize += SIG_HEADER_SIZE;
	CircleSwap(&Temp1,dwTemp1Size);

	// Build the signature packet in lpKeyBuffer2
	//...........................................
	__asm
	{
		mov		edi,lpKeyBuffer2
		mov		al,CTB_SKE_PACKET
		or		al,LENGTH_2
		stosb

		// Length of signature packet. Does not include CTB and
		// length field size.
		//.....................................................
		mov		eax,dwSignatureSize
		sub		eax,(CTB_SIZE + LENGTH_2_SIZE)
		xchg	ah,al
		stosw

		// Version of 3.
		//..............
		mov		al,VERSION_NEW
		stosb

		// Length of message digest material.
		//...................................
		
		mov		al,DigestSize
		stosb

		// Signature classification field.
		//................................
		mov		eax,dwTypeOfSignature
		stosb

		// Get the Gmt timestamp.
		//.......................
		mov		eax,dwOurTimestamp
		stosd

		// Get the 64 bit key id.
		//.......................
		mov		eax,dword ptr KeySID
		stosd
		mov		eax,dword ptr KeySID[4]
		stosd

		// Store the two algorithm bytes.
		//...............................
		mov		al,RSA_ALGORITHM
		
		// Put in the extra 7 bits of the timestamp for Sha digest.
		//.........................................................
		mov		edx,dwOurTimestamp1
		shl		dl,1
		or		al,dl
		stosb

		// Put in the Md5 or Sha1 or Sha512 algorithm byte.
		//.................................................
		mov		al,SHA512_ALGORITHM
		cmp		bUseSha512,1
		jz		L3
		mov		al,SHA_ALGORITHM
	L3:	cmp		bUseMd5,0
		jz		L2
		mov		al,MD5_ALGORITHM
	L2: stosb

		// Store the first two bytes of the Md5, Sha1, or Sha512 message digest.
		//......................................................................
		mov		ax,wMd5Byte1
		stosw

		// Store the Rsa integer.
		//.......................
		mov		eax,dwTemp1Bits
		xchg	ah,al
		stosw

		mov		esi,offset Temp1
		mov		ecx,dwTemp1Size
		rep		movsb

		// Now add a signature trust packet if this is not a
		// compromise certificate.
		//..................................................
		cmp		dwTypeOfSignature,KEY_COMPROMISE
		je		L1
		mov		al,CTB_TRUST
		or		al,LENGTH_1
		stosb
		mov		al,1
		stosb
		xor		al,al
		stosb
		add		dwSignatureSize,TRUST_PCKT_SIZE
	L1:
	}
}

// Setup the key ring file names for the status bar.
//..................................................
VOID KeyRingsForStatusBar()
{
	LPTSTR		lpPublicKey;
	LPTSTR		lpSecretKey;

	bDisplayRingsOnStatusBar = TRUE;

	lpPublicKey = GetDisplayName(&shfi1,(LPCTSTR)&cfg.szPublicKeyRing);
	lpSecretKey = GetDisplayName(&shfi2,(LPCTSTR)&cfg.szSecretKeyRing);

	StringCbPrintf((LPTSTR)&szStatusBarRings,sizeof(szStatusBarRings),(LPCTSTR)&szRings,
				    lpPublicKey,lpSecretKey);

	if (lstrlen((LPCTSTR)&szStatusBarRings) < sizeof(szRings))
	{
		bDisplayRingsOnStatusBar = FALSE;
	}
	if (!bTimerOn && bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
}

// Get the address of the display name for a file. Will return a name
// based on the global windows setting for showing known file extensions.
//.......................................................................
LPVOID GetDisplayName(LPSHFILEINFO pshfi, LPCTSTR lpszPath)
{
	DWORD		dwResults;

	ZeroMemory(pshfi,sizeof(SHFILEINFO));

	dwResults = SHGetFileInfo(lpszPath,0,pshfi,sizeof(SHFILEINFO),SHGFI_DISPLAYNAME);
	if (dwResults)
	{
		return(&pshfi->szDisplayName);
	}
	else
	{
		return(PathFindFileName(lpszPath));
	}
}

